using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    struct Point : IComparable<Point>
    {
        public int X, Y;
        public Point(int x, int y) { X = x; Y = y; }
        public int CompareTo(Point other) => X != other.X ? X.CompareTo(other.X) : Y.CompareTo(other.Y);
    }

    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        List<Point> points = new List<Point>();
        for (int i = 0; i < n; i++)
        {
            var coords = Console.ReadLine().Split().Select(int.Parse).ToArray();
            points.Add(new Point(coords[0], coords[1]));
        }

        long minArea = long.MaxValue;

        for (int i = 0; i < points.Count; i++)
        {
            List<Point> reducedPoints = points.Where((_, index) => index != i).ToList();
            List<Point> hull = ConvexHull(reducedPoints);
            long area = CalculateArea(hull);
            minArea = Math.Min(minArea, area);
        }

        Console.WriteLine(minArea);
    }

    static List<Point> ConvexHull(List<Point> points)
    {
        points.Sort();
        List<Point> hull = new List<Point>();

        foreach (var p in points)
        {
            while (hull.Count >= 2 && Cross(hull[hull.Count - 2], hull[hull.Count - 1], p) <= 0)
                hull.RemoveAt(hull.Count - 1);
            hull.Add(p);
        }

        int lowerCount = hull.Count;
        for (int i = points.Count - 2; i >= 0; i--)
        {
            while (hull.Count > lowerCount && Cross(hull[hull.Count - 2], hull[hull.Count - 1], points[i]) <= 0)
                hull.RemoveAt(hull.Count - 1);
            hull.Add(points[i]);
        }

        hull.RemoveAt(hull.Count - 1);
        return hull;
    }

    static long Cross(Point p1, Point p2, Point p3)
    {
        return (long)(p2.X - p1.X) * (p3.Y - p1.Y) - (long)(p2.Y - p1.Y) * (p3.X - p1.X);
    }

    static long CalculateArea(List<Point> polygon)
    {
        long area = 0;
        for (int i = 0; i < polygon.Count; i++)
        {
            Point p1 = polygon[i];
            Point p2 = polygon[(i + 1) % polygon.Count];
            area += (long)p1.X * p2.Y - (long)p1.Y * p2.X;
        }
        return Math.Abs(area) / 2;
    }
}